 /* 'mrABO.h' */

 /* Nagwek typw bazowych Mirus */
#include "mrDatatypes.h"
 /* Nagowek identyfikacji bdw Mirus */
#include "mrError.h"
 /* Nagwek tekstury Mirus */
#include "mrTexture.h"
 /* Nagwek animacji Mirus */
#include "mrAnimation.h"
/* Nagwek grafiki DirectX */
#include <d3d8.h> 

 /* Zacz ten plik tylko raz */
#pragma once

 /* Klasa obiektu animowanego ABO */
class mrABO
{
protected:
 mrAnimation *    m_pkAnimations;
 mrUInt32         m_iCurrentAnimation;

 mrUInt32         m_iColor;

 mrUInt32         m_iXPosition;
 mrUInt32         m_iYPosition;

 mrUInt32         m_iWidth;
 mrUInt32         m_iHeight;

 mrReal32         m_fAngle;
 mrReal32         m_fRadius;

  /* Tylko w przypadku adowania z pliku */
 mrTexture *      m_pkTexture;

public:
  /* Konstruktory / Destruktor */
 mrABO (void);
 ~mrABO (void);

  /* Metody manipulujce obiektem ABO */
 void Create (mrUInt32 iAnimations, mrAnimation * pkAnimations);
 void Update (void);

 void SetAnimation (mrUInt32 iAnimation, mrAnimation * pkAnimation);
 void LoadFromFile (LPSTR lpszFilename);

 mrError32 Render (void);

 void Rotate (mrReal32 fAngle, mrUInt32 iAccumulate);

 mrBool32 Collide (mrABO & rkABO, mrUInt32 iUseSphere);
 mrBool32 ContainsPoint (mrInt32 iX, mrInt32 iY);

  /* Metody obsugowe ABO */
 void SetCurrentAnimation (mrUInt32 iAnimation);
 mrUInt32 GetCurrentAnimation (void);

 void SetPosition (mrUInt32 iX, mrUInt32 iY);
 void SetSize (mrUInt32 iWidth, mrUInt32 iHeight);
 void SetColor (mrUInt8 iAlpha, mrUInt8 iRed, mrUInt8 iGreen,
                mrUInt8 iBlue);
 void SetRadius (mrReal32 fRadius);

 mrUInt32 GetXPosition (void);
 mrUInt32 GetYPosition (void);
 mrUInt32 GetHeight (void);
 mrUInt32 GetWidth (void);
 mrUInt32 GetColor (void);
 mrReal32 GetDirection (void);
 mrReal32 GetRadius (void);
};

